/*
 * $Id: //devel/tools/main/datemath/defs.h#1 $
 *
 * written by:  Stephen J. Friedl
 *              Software Consultant
 *              Tustin, California USA
 *              steve@unixwiz.net / www.unixwiz.net
 *
 *	Various macros and stuff needed for datemath. These must be
 *	included in ALL moduled, including the lexer and parser.
 */
#define		TRUE		1
#define		FALSE		0

/*------------------------------------------------------------------------
 * arguments to exit (normally provided in <stddef.h>)
 */
#ifndef	EXIT_SUCCESS
#  define	EXIT_SUCCESS	0
#  define	EXIT_FAILURE	1
#endif

#ifndef __GNUC__
#  define	__attribute__(x)	/*nothing*/
#endif

/*------------------------------------------------------------------------
 * indexes into the month/day/year `mdy[3]' arrays.
 */
#define		MM		0
#define		DD		1
#define		YY		2

extern void die( char const *, ... ) __attribute__((noreturn))
                                     __attribute__((format(printf,1,2)));

extern const char *ProgName;

typedef unsigned long jdate_t;

#define YYSTYPE jdate_t

extern int	daysinyymm(int yymm)            __attribute__((const));
extern int	daysinmm(int, int)              __attribute__((const));
extern int	yymm_add(int yymm, int nmonths) __attribute__((const));
extern jdate_t	yymmtojul(int yymm, int eflag)  __attribute__((const));
extern int	jultoyymm(jdate_t jdate)        __attribute__((const));

/* jdate.c */

extern int	rtoday(jdate_t *pjdate);
extern int	rjulmdy(jdate_t jdate, short *mdy);
extern int	rmdyjul(const short *mdy, jdate_t *jpdate);
extern int	rdatestr(jdate_t jdate, char *str);
extern int	rfmtdate(jdate_t, const char *, char *);

/* lex.l */
extern void	init_scan(char *p);

/* gram.y */
extern int	yyparse(void);
extern int	yylex(void);
extern void	yyerror(const char *);
extern char	*yytext;

extern int      year_to_yyyy(int yy) __attribute__((const));
extern int      century19_year;
extern int	year_digits;
extern int	collate_order;
extern char	*strlower(char *s);
